	function [iedge,ides,iwt,igrid] = newgrid(edge,des,wt,ngrid)
	
	% Creates equally spaced grid vector.
	% Main function linremez.m calls this in two occasion.
	% First time when creating equally spaced grid vector using command line
	% parameters.
	% Second only in 2-band cases when algorithm cannot find solution, then
	% algorithm automatically increases amount of grind points and calls this
	% subroutine again.
	% <---------------------------------------------------------------<< DH <<<
	% SYM_WDF.m -> linremez.m -> newgrid.m
	%                          -> iextnew.m
	%                          -> forcing.m -> forcehelp.m -> phas.m
	%                          -> phas.m
	%                          -> removeiext.m
	%            -> factors.m 
	% <---------------------------------------------------------------<< DH <<<
	%
	% ngrid     numbers of grid points
	% edge      band edges
	% wt        weights for the bands, one value per band or one value 
	%           per grid point
	% des       desired values for the bands
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	 
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi
	
	
	% Testing
	% >> [ie2,d2,w2,ig2] = newgrid([0 .12 .17 .19 .27 .5],[0 -1 -2],[1 1 1],69)
	% >> figure(1);plot(igrid2,[ones(1,69)],'.');
	
	% <--- edited May-14-2008 with MATLAB R2006a ---------------------<< DH <<<
	
	des = des*pi;                         %[0 -pi -2*pi]
	bwt = 0;                              % total bandwidth
	for i = 1:length(edge)/2
		bw(i) = edge(2*i)-edge(2*i-1);    % i:th band width
		bwt = bwt+bw(i);                  % combining total bandwidth
	end
	igridband = fix((bw/bwt)*ngrid+0.5);              % making sure that there
	igridband(end) = ngrid-sum(igridband(1:end-1));   % are right amount of grid
	% points after rounding
	grid = [];wtps = [];desps = [];                                              
	for i = 1:length(edge)/2
		gridp = linspace(edge(2*i-1),edge(2*i),igridband(i));
		wtp = ones(1,length(gridp))*wt(i);
		desp = ones(1,length(gridp))*des(i);
		if (i == 1);
			iedge(1:2) = [1 length(gridp)];    
		elseif (i == length(edge)/2); 
			iedge(2*i-1:2*i) = [iedge(2*i-2)+1 iedge(2*i-2)+length(gridp)];
		else
			iedge(2*i-1:2*i) = [iedge(2*i-2)+1 iedge(2*i-2)+length(gridp)];
		end
		grid = [grid gridp];wtps = [wtps wtp];desps = [desps desp];
	end
	igrid = grid;iwt = wtps;ides = desps;
